package org.msh.tb.reports2.variables.contacts;

import org.msh.reports.keys.Key;
import org.msh.tb.reports2.ReportResources;
import org.msh.tb.reports2.VariableImpl;

/**
 * Created by msantos on 15/12/17.
 */
public class AgeRange3Variable extends VariableImpl {

    public static final int AGE_0TO4 = 1;
    public static final int AGE_5TO14 = 2;
    public static final int AGE_15TO24 = 3;
    public static final int AGE_25TO34 = 4;
    public static final int AGE_35TO44 = 5;
    public static final int AGE_45TO54 = 6;
    public static final int AGE_55TO64 = 7;
    public static final int OVER65 = 8;


    public AgeRange3Variable() {
        super(ReportResources.VAR_AGERANGE3, "TbCase.age", "tbcase.age");
    }

    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#createKey(java.lang.Object)
     */
    @Override
    public Key createKey(Object values, int iteration) {
        if (values == null) {
            return Key.asNull();
        }

        // get the age
        int age = (Integer)values;

        if (age <= 4) {
            return Key.of(AGE_0TO4);
        }

        if (age <= 14) {
            return Key.of(AGE_5TO14);
        }

        if (age <= 24) {
            return Key.of(AGE_15TO24);
        }

        if (age <= 34) {
            return Key.of(AGE_25TO34);
        }

        if (age <= 44) {
            return Key.of(AGE_35TO44);
        }

        if (age <= 54) {
            return Key.of(AGE_45TO54);
        }

        if (age <= 64) {
            return Key.of(AGE_55TO64);
        }

        return Key.of(OVER65);
    }

    @Override
    public String getDisplayText(Key key) {
        // if it's null, return undefined
        if (key.isNull()) {
            return super.getDisplayText(key);
        }

        switch ((Integer)key.getValue()) {
            case AGE_0TO4: return "0-4";
            case AGE_5TO14: return "5-14";
            case AGE_15TO24: return "15-24";
            case AGE_25TO34: return "25-34";
            case AGE_35TO44: return "35-44";
            case AGE_45TO54: return "45-54";
            case AGE_55TO64: return "55-64";
            default: return "≥ 65";
        }
    }

    @Override
    public int compareValues(Key key1, Key key2) {
        Integer val1 = (Integer)key1.getValue();
        Integer val2 = (Integer)key2.getValue();

        if (val1 == val2) {
            return 0;
        }

        if (val1 != null && val2 != null) {
            return ((Integer)val1).compareTo((Integer)val2);
        }

        return super.compareValues(key1, key2);
    }
}
